﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp1
{
    internal class Program
    {
        [DllImport("HandEyeSDK.dll")]
        static extern int DetectConcentricCircles2D(string imageFilePath, ref int resultNum, float[] resultPixelXy);

        [DllImport("HandEyeSDK.dll")]
        static extern int DetectConcentricCircles3D(string imageFilePath, string pointCloudFilePath,
            ref int resultNum, float[] resultPixelXy, float[] resultPointXyz);

        [StructLayoutAttribute(LayoutKind.Sequential)]
        public struct HandEyeParam
        {
            public int poseType; // 0: euler angle, 1: wxyz, 2: xyzw, 3: matrix
            public int markerType; // 0: 4*11 caliboard, 1: concentric circle. If use HandEyeCalibrationTcpTouch(), ignore this parameter.

            [MarshalAs(UnmanagedType.I1)]
            public bool isPointCloudMm;

            [MarshalAs(UnmanagedType.I1)]
            public bool isPoseMm;

            [MarshalAs(UnmanagedType.I1)]
            public bool isPoseDegree;

            [MarshalAs(UnmanagedType.I1)]
            public bool isEyeInHand;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 100, ArraySubType = UnmanagedType.I1)]
            public bool[] dataMask;
        };

        [StructLayoutAttribute(LayoutKind.Sequential)]
        public struct HandEyeResult
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
            public double[] translationResult; // x y z

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
            public double[] eulerAngleResult; // r1 r2 r3. If poseType equals euler angle, this field has result.

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            public double[] quaternionResult;  // w x y z or x y z w. If poseType equals quaternion, this field has result.

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
            public double[] matrix;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 100)]
            public int[] success2D;  // 0: failed, 1: success, 2: not exist image file.

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 100)]
            public int[] success3D;  // 0: failed, 1: success, 2: not exist point cloud file.

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 100)]
            public double[] error;

            public double totalMeanError;
        }

        [DllImport("HandEyeSDK.dll")]
        static extern int HandEyeCalibrationMarker(string folder, string robotPoseFileName, HandEyeParam p, ref HandEyeResult r);

        [DllImport("HandEyeSDK.dll")]
        static extern int HandEyeCalibrationTcpTouch(
            string cameraXyzFilePath, string robotPoseFilePath, string tcpXyzFilePath, HandEyeParam p, ref HandEyeResult r);

        static void TestDetectConcentricCircles(string imageFilePath, string pointCloudFilePath)
        {
            int resultNum = 0;
            float[] resultPixelXy = new float[200];
            float[] resultPointXyz = new float[300];
            DetectConcentricCircles3D(imageFilePath, pointCloudFilePath, ref resultNum, resultPixelXy, resultPointXyz);
            Console.WriteLine("Result num: " + resultNum);
            for (int i = 0; i < resultNum; i++)
            {
                Console.WriteLine("Result Pixel X Y: " + resultPixelXy[i * 2] + " " + resultPixelXy[i * 2 + 1]);
                Console.WriteLine("Result Point X Y Z: " + resultPointXyz[i * 3] + " " + resultPointXyz[i * 3 + 1] + " " + resultPointXyz[i * 3 + 2]);
            }

            return;
        }

        static void TestHandEyeCalibrationMarker(string folder, string robotPoseFileName)
        {
            HandEyeParam p = new HandEyeParam();
            p.poseType = 0;
            p.markerType = 1;
            p.isPointCloudMm = false;
            p.isPoseMm = true;
            p.isPoseDegree = true;
            p.isEyeInHand = true;
            p.dataMask = new bool[100];
            for (int i = 0; i < 100; i++)
            {
                p.dataMask[i] = true;
            }
            // If you do not want to use 5th data, set it to false
            // p.dataMask[5] = false;

            HandEyeResult finalRes = new HandEyeResult();
            int ret2 = HandEyeCalibrationMarker(folder,
                robotPoseFileName, p,
                ref finalRes);

            if (ret2 != 0)
            {
                Console.WriteLine("HandEyeCalibration failed! Error code: " + ret2);
                return;
            }
            Console.WriteLine("HandEyeCalibration success!");
            Console.WriteLine("Result: " + finalRes.translationResult[0] + " " + finalRes.translationResult[1] + " " + finalRes.translationResult[2] + " "
                + finalRes.eulerAngleResult[0] + " " + finalRes.eulerAngleResult[1] + " " + finalRes.eulerAngleResult[2]);
            Console.WriteLine("Result matrix: ");
            Console.WriteLine(
                finalRes.matrix[0] + " " + finalRes.matrix[1] + " " + finalRes.matrix[2] + " " + finalRes.matrix[3] + "\n" +
                finalRes.matrix[4] + " " + finalRes.matrix[5] + " " + finalRes.matrix[6] + " " + finalRes.matrix[7] + "\n" +
                finalRes.matrix[8] + " " + finalRes.matrix[9] + " " + finalRes.matrix[10] + " " + finalRes.matrix[11] + "\n" +
                finalRes.matrix[12] + " " + finalRes.matrix[13] + " " + finalRes.matrix[14] + " " + finalRes.matrix[15] + "\n"
            );
            Console.WriteLine("Error: " + finalRes.totalMeanError);
            return;
        }

        static void TestHandEyeCalibrationHandEyeCalibrationTcpTouch(
            string cameraXyzFilePath, string robotPoseFilePath, string tcpXyzFilePath) {
            HandEyeParam p = new HandEyeParam();
            p.poseType = 0;
            p.isPointCloudMm = false;
            p.isPoseMm = true;
            p.isPoseDegree = true;
            p.isEyeInHand = true;
            p.dataMask = new bool[100];
            for (int i = 0; i < 100; i++) {
                p.dataMask[i] = true;
            }
            // If you do not want to use 5th data, set it to false
            // p.dataMask[5] = false;

            HandEyeResult finalRes = new HandEyeResult();
            int ret = HandEyeCalibrationTcpTouch(cameraXyzFilePath, robotPoseFilePath, tcpXyzFilePath, p, ref finalRes);

            if (ret != 0) {
                Console.WriteLine("HandEyeCalibration failed! Error code: " + ret);
                return;
            }
            Console.WriteLine("HandEyeCalibration success!");
            Console.WriteLine("Result: " + finalRes.translationResult[0] + " " + finalRes.translationResult[1] + " " + finalRes.translationResult[2] + " "
                + finalRes.eulerAngleResult[0] + " " + finalRes.eulerAngleResult[1] + " " + finalRes.eulerAngleResult[2]);
            Console.WriteLine("Result matrix: ");
            Console.WriteLine(
                finalRes.matrix[0] + " " + finalRes.matrix[1] + " " + finalRes.matrix[2] + " " + finalRes.matrix[3] + "\n" +
                finalRes.matrix[4] + " " + finalRes.matrix[5] + " " + finalRes.matrix[6] + " " + finalRes.matrix[7] + "\n" +
                finalRes.matrix[8] + " " + finalRes.matrix[9] + " " + finalRes.matrix[10] + " " + finalRes.matrix[11] + "\n" +
                finalRes.matrix[12] + " " + finalRes.matrix[13] + " " + finalRes.matrix[14] + " " + finalRes.matrix[15] + "\n"
            );
            Console.WriteLine("Error: " + finalRes.totalMeanError);
            return;
        }

        static void Main(string[] args)
        {
           // TestHandEyeCalibrationMarker("D:\\HandEyeCalibrationData\\汉立10/", "pose.txt");
            //TestDetectConcentricCircles("D:\\HandEyeCalibrationData\\handingeye_data\\handingeye_data\\annulus/0.png",
            //    "D:\\HandEyeCalibrationData\\handingeye_data\\handingeye_data\\annulus/0.ply");

            string folder = "D:/";
            string cameraXyzFilePath = folder + "cameraCapturePointXyz.txt";
            string robotPoseFilePath = folder + "cameraCaptureRobotPose.txt";
            string tcpXyzFilePath = folder + "tcp.txt";
            TestHandEyeCalibrationHandEyeCalibrationTcpTouch(cameraXyzFilePath, robotPoseFilePath, tcpXyzFilePath);
        }
    }
}
